/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.GridPoint2;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.behaviour.HumanoidBehaviour;
import technology.rocketjump.undermount.entities.behaviour.furniture.CraftingStationBehaviour;
import technology.rocketjump.undermount.entities.behaviour.furniture.DoorBehaviour;
import technology.rocketjump.undermount.entities.factories.ItemEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.WorkOnJobGoal;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.messaging.types.ItemCreationRequestMessage;
import technology.rocketjump.undermount.messaging.types.ItemDestroyedMessage;
import technology.rocketjump.undermount.messaging.types.TreeFallenMessage;
import technology.rocketjump.undermount.rooms.ItemAllocation;

@Singleton
public class EntityMessageHandler
implements GameContextAware,
Telegraph {
    private final MessageDispatcher messageDispatcher;
    private final EntityAssetUpdater entityAssetUpdater;
    private final ItemEntityFactory itemEntityFactory;
    private final GameMaterialDictionary gameMaterialDictionary;
    private GameContext gameContext;

    @Inject
    public EntityMessageHandler(MessageDispatcher messageDispatcher, EntityAssetUpdater entityAssetUpdater, ItemEntityFactory itemEntityFactory, GameMaterialDictionary gameMaterialDictionary) {
        this.messageDispatcher = messageDispatcher;
        this.entityAssetUpdater = entityAssetUpdater;
        this.itemEntityFactory = itemEntityFactory;
        this.gameMaterialDictionary = gameMaterialDictionary;
        messageDispatcher.addListener(this, 322);
        messageDispatcher.addListener(this, 608);
        messageDispatcher.addListener(this, 323);
        messageDispatcher.addListener(this, 324);
        messageDispatcher.addListener(this, 703);
        messageDispatcher.addListener(this, 325);
        messageDispatcher.addListener(this, 808);
        messageDispatcher.addListener(this, 701);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 325: {
                Entity createdEntity = (Entity)msg.extraInfo;
                this.gameContext.getEntityStore().add(createdEntity, this.gameContext.getAreaMap());
                return true;
            }
            case 322: {
                EntityMessage entityMessage = (EntityMessage)msg.extraInfo;
                long entityId = entityMessage.getEntityId();
                Entity removed = this.gameContext.getEntityStore().remove(entityId);
                if (removed != null) {
                    MapTile mapTile;
                    if (removed.getType().equals((Object)EntityType.ITEM)) {
                        this.messageDispatcher.dispatchMessage(702, new ItemDestroyedMessage(removed.getId(), (ItemEntityAttributes)removed.getPhysicalEntityComponent().getAttributes()));
                    }
                    if (removed.getLocationComponent().getWorldPosition() != null && (mapTile = this.gameContext.getAreaMap().getTile(removed.getLocationComponent().getWorldPosition())) != null) {
                        mapTile.removeEntity(entityId);
                    }
                }
                return true;
            }
            case 608: {
                HumanoidBehaviour behaviour;
                EntityMessage entityMessage = (EntityMessage)msg.extraInfo;
                long entityId = entityMessage.getEntityId();
                Entity entity = this.gameContext.getEntityStore().getById(entityId);
                if (entity != null && entity.getBehaviourComponent() instanceof HumanoidBehaviour && (behaviour = (HumanoidBehaviour)entity.getBehaviourComponent()).getCurrentGoal() instanceof WorkOnJobGoal) {
                    behaviour.clearCurrentGoal();
                }
                return true;
            }
            case 323: {
                return this.handle((TreeFallenMessage)msg.extraInfo);
            }
            case 324: {
                Entity entity = (Entity)msg.extraInfo;
                if (entity != null) {
                    this.entityAssetUpdater.updateEntityAssets(entity);
                }
                return true;
            }
            case 703: {
                return this.handle((ItemCreationRequestMessage)msg.extraInfo);
            }
            case 701: {
                ItemAllocation allocation = (ItemAllocation)msg.extraInfo;
                if (allocation.getTargetType().equals((Object)ItemAllocation.AllocationTargetType.FURNITURE)) {
                    Entity itemEntity;
                    Entity targetFurnitureEntity = this.gameContext.getEntityStore().getById(allocation.getTargetId());
                    if (targetFurnitureEntity != null) {
                        ((CraftingStationBehaviour)targetFurnitureEntity.getBehaviourComponent()).allocationCancelled(allocation);
                    }
                    if ((itemEntity = this.gameContext.getEntityStore().getById(allocation.getItemEntityId())) != null) {
                        ItemEntityAttributes attributes = (ItemEntityAttributes)itemEntity.getPhysicalEntityComponent().getAttributes();
                        attributes.setNumAllocated(attributes.getNumAllocated() - allocation.getQuantity());
                    }
                    return true;
                }
                return false;
            }
            case 808: {
                EntityMessage entityMessage = (EntityMessage)msg.extraInfo;
                Entity doorEntity = this.gameContext.getEntityStore().getById(entityMessage.getEntityId());
                DoorBehaviour doorBehaviour = (DoorBehaviour)doorEntity.getBehaviourComponent();
                doorBehaviour.doorOpenRequested();
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private boolean handle(ItemCreationRequestMessage message) {
        ItemEntityAttributes attributes = new ItemEntityAttributes(this.gameContext.getRandom().nextLong());
        attributes.setItemType(message.getRequiredItemType());
        for (GameMaterialType requiredMaterialType : message.getRequiredItemType().getMaterialTypes()) {
            List<GameMaterial> materialsToPickFrom = this.gameMaterialDictionary.getByType(requiredMaterialType);
            if (requiredMaterialType.equals((Object)GameMaterialType.METAL)) {
                materialsToPickFrom.clear();
                materialsToPickFrom.add(this.gameMaterialDictionary.getByName("Iron"));
                materialsToPickFrom.add(this.gameMaterialDictionary.getByName("Steel"));
            }
            GameMaterial material = materialsToPickFrom.get(this.gameContext.getRandom().nextInt(materialsToPickFrom.size()));
            attributes.setMaterial(material);
        }
        attributes.setQuantity(1);
        attributes.setNumAllocated(0);
        Entity item = this.itemEntityFactory.create(attributes, null, this.gameContext.getAreaMap());
        message.getCallback().itemCreated(item);
        return true;
    }

    private boolean handle(TreeFallenMessage treeFallenMessage) {
        GridPoint2 treeTilePosition = new GridPoint2((int)Math.floor(treeFallenMessage.getTreeWorldPosition().x), (int)Math.floor(treeFallenMessage.getTreeWorldPosition().y));
        int logsToCreateAtNextTile = 1;
        int logsLeftToCreate = treeFallenMessage.getNumLogsToCreate();
        PlantSpecies treeSpecies = treeFallenMessage.getTreeSpecies();
        if (treeSpecies.getItem() != null) {
            for (int xOffset = logsLeftToCreate; xOffset > 0; --xOffset) {
                GridPoint2 targetTilePosition = treeFallenMessage.isFallToWest() ? treeTilePosition.cpy().sub(xOffset, 0) : treeTilePosition.cpy().add(xOffset, 0);
                MapTile targetTile = this.gameContext.getAreaMap().getTile(targetTilePosition);
                if (targetTile != null && targetTile.isNavigable()) {
                    ItemEntityAttributes itemEntityAttributes = new ItemEntityAttributes(this.gameContext.getRandom().nextLong());
                    itemEntityAttributes.setItemSize(treeSpecies.getItem().getItemSize());
                    itemEntityAttributes.setItemStyle(treeSpecies.getItem().getItemStyle());
                    itemEntityAttributes.setColor(ColoringLayer.BRANCHES_COLOR, treeFallenMessage.getBranchColor());
                    itemEntityAttributes.setQuantity(logsToCreateAtNextTile);
                    itemEntityAttributes.setMaterial(treeSpecies.getBranchMaterial());
                    itemEntityAttributes.setItemType(treeSpecies.getItem().getItemType());
                    Entity matchingItem = targetTile.getItemMatching(itemEntityAttributes);
                    if (matchingItem != null || !targetTile.hasItem()) {
                        this.gameContext.getEntityStore().createResourceItem(itemEntityAttributes, targetTilePosition, this.gameContext.getAreaMap());
                        logsToCreateAtNextTile = 0;
                    }
                }
                ++logsToCreateAtNextTile;
            }
        } else {
            System.err.println("No item to be produced from " + treeSpecies);
        }
        return true;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

